//*********************************************************************
// file			: I2C.c
// version		: V1.0
// brief		: I2C related functions
// note			: I2C related functions are gathered in this subroutine
//*********************************************************************

#include "MQ6822.h"
#include "iApp.h"
#include "I2C.h"


//*********************************************************************
// name			: I2C_set()
// brief		: SBI0
// note			:
//*********************************************************************
void I2C_set(void)
{
	P2CR.bit.b3  = 0;
	P2CR.bit.b4  = 0;
	POFFCR1.bit.b4  = 1;		//SBI0 Enable
	while( P2PRD.bit.b3==0 || P2PRD.bit.b4==0 ){ WDCDR.byte = 0x4e; }	// wait for high level
	P2DR.bit.b3  = 1;
	P2DR.bit.b4  = 1;
	P2CR.bit.b3  = 1;
	P2CR.bit.b4  = 1;
	P2FC.bit.b3  = 1;
	P2FC.bit.b4  = 1;
	SBI0CR2.byte = 0x18;
	SBI0CR1.byte = 0x10;
//	SBI0CR1*************************
//	SBI0CR1.bit.b7  = 0;		// BC: Number of data bits
//	SBI0CR1.bit.b6  = 0;		// BC: Number of data bits
//	SBI0CR1.bit.b5  = 0;		// BC: Number of data bits
//	SBI0CR1.bit.b4  = 1;		// ACK
//	SBI0CR1.bit.b3  = 0;		// NOACK: master Don't care
//	SBI0CR1.bit.b2  = 0;		// SCK
//	SBI0CR1.bit.b1  = 0;		// SCK
//	SBI0CR1.bit.b0  = 0;		// SCK
//	SBI0CR2: byte operation not bit *************************
//	SBI0CR2.bit.b7  = 0;		// MST: 0.Slave, 1.Master
//	SBI0CR2.bit.b6  = 0;		// TRX: 0.Receiver, 1.Transmitter
//	SBI0CR2.bit.b5  = 0;		// BB:  Generate the condition, 0.stop, 1.start
//	SBI0CR2.bit.b4  = 1;		// PIN: 1.Cancel interrupt service request
//	SBI0CR2.bit.b3  = 1;		// SBIM: 0.Port mode, 1.Serial bus interface mode
//	SBI0CR2.bit.b2  = 0;		// NA
//	SBI0CR2.bit.b1  = 0;		// SWRST: Software reset start bit
//	SBI0CR2.bit.b0  = 0;		// SWRST: Software reset start bit
//	I2C0AR*************************
//	I2C0AR.byte     = 0;		// [7:1] SA0: Slave address setting

}


//*********************************************************************
// name			: I2C_start()
// brief		: I2C_start
// note			:
//*********************************************************************
void I2C_start(uchar data)
{
	uchar tWait = 0;

	while( SBI0SR2.bit.b5 == 1 ){}	// SBI0SR2.BB: confirms bus is free

//****** Write data to the registers before the start condition is generated ******
	SBI0DBR.byte = data;
	SBI0CR2.byte = 0xf8;			// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request
	while( SBI0SR2.bit.b0 == 1 )	// wait for last received bit is "0"
	{								// if no response, SCK is always low level
		tWait++;
		if( tWait>250 )				// jump out of loop if no response for too long
		{
			I2C_stop();				// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// name			: I2C_restart()
// brief		: I2C_restart
// note			:
//*********************************************************************
void I2C_restart(uchar data)
{
	uchar tWait = 0;

	SBI0CR2.byte = 0x18;
	while( SBI0SR2.bit.b5 == 1 ){}	// SBI0SR2.BB: confirms bus is free
	while( SBI0SR2.bit.b0 == 0 ){}	// wait <LRB>=1**********************

//****** Write data to the registers before the start condition is generated ******
	SBI0DBR.byte = data;
	SBI0CR2.byte = 0xf8;			// Write "1" to SBI0CR2<MST>, <TRX>, <BB>, <PIN>  and <SBIM>to "1"
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request
	while( SBI0SR2.bit.b0 == 1 )	// wait for last received bit is "0"
	{								// if no response, SCK is always low level
		tWait++;
		if( tWait>250 )				// jump out of loop if no response for too long
		{
			I2C_stop();				// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// name			: I2C_stop()
// brief		: I2C_stop
// note			:
//*********************************************************************
void I2C_stop(void)
{
	SBI0CR2.byte = 0xd8;			// Set SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
	while( SBI0SR2.bit.b5 == 1 ){}	// SBI0SR2.BB: confirms bus is free
}


//*********************************************************************
// name			: I2C_ByteWrite()
// brief		: write one byte of data
// note			:
//*********************************************************************
void I2C_ByteWrite(uchar data)
{
	uchar tWait = 0;

	SBI0DBR.byte = data;
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request
	while( SBI0SR2.bit.b0 == 1 )	// wait for last received bit is "0"
	{								// if no response, SCK is always low level
		tWait++;
		if( tWait>250 )				// jump out of loop if no response for too long
		{
			I2C_stop();				// I2C stop -> release SCK
			break;
		}
	}
}


//*********************************************************************
// name			: I2C_ByteRead()
// brief		: read one byte of data
// note			:
//*********************************************************************
uchar I2C_ByteRead(void)
{
	uchar temp_Data;

//	SBI0CR1.bit.b4 = 1;				// ACK=1
	SBI0DBR.byte   = 0x00;			// write dummy data to set PIN = 1
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request
	temp_Data = SBI0DBR.byte;

	return temp_Data;
}


//*********************************************************************
// name			: I2C_ByteRead_Last()
// brief		: read last byte of data
// note			:
//*********************************************************************
uchar I2C_ByteRead_Last(void)
{
	uchar temp_Data;

	SBI0CR1.bit.b4 = 0;				// ACK=0
	SBI0DBR.byte   = 0x00;			// write dummy data to set PIN = 1
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request
	temp_Data = SBI0DBR.byte;

//	Termination of data transfer by master mode
//	Sent 1 bit negative acknowledge............
	SBI0CR1.bit.b5 = 1;				// BC, bit count = 1
	SBI0DBR.byte   = 0x00;			// write dummy data to set PIN = 1
	while( SBI0SR2.bit.b4 == 1 ){}	// wait for releasing interrupt service request

	return temp_Data;
}









